/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import java.util.Arrays;

public class PagedMemory {
    private byte[][] internalMemory = new byte[0][];
    private Type type;

    public PagedMemory(int size, Type memType) {
        this.type = memType;
        this.internalMemory = new byte[size >> 8][256];
        for (int i = 0; i < size; i += 256) {
            byte[] b = new byte[256];
            Arrays.fill(b, (byte)0);
            this.internalMemory[i >> 8] = b;
        }
    }

    public PagedMemory(byte[] romData, Type memType) {
        this.type = memType;
        this.loadData(romData);
    }

    public void loadData(byte[] romData) {
        for (int i = 0; i < romData.length; i += 256) {
            byte[] b = new byte[256];
            for (int j = 0; j < 256; ++j) {
                b[j] = romData[i + j];
            }
            this.internalMemory[i >> 8] = b;
        }
    }

    public void loadData(byte[] romData, int offset, int length) {
        for (int i = 0; i < length; i += 256) {
            byte[] b = new byte[256];
            for (int j = 0; j < 256; ++j) {
                b[j] = romData[offset + i + j];
            }
            this.internalMemory[i >> 8] = b;
        }
    }

    public byte[][] getMemory() {
        return this.internalMemory;
    }

    public byte[] get(int pageNumber) {
        return this.internalMemory[pageNumber];
    }

    public void set(int pageNumber, byte[] bank) {
        this.internalMemory[pageNumber] = bank;
    }

    public byte[] getMemoryPage(int memoryBase) {
        int offset = memoryBase - this.type.baseAddress;
        int page = offset >> 8 & 0xFF;
        return this.internalMemory[page];
    }

    public void setBanks(int sourceStart, int sourceLength, int targetStart, PagedMemory source) {
        for (int i = 0; i < sourceLength; ++i) {
            this.set(targetStart + i, source.get(sourceStart + i));
        }
    }

    public byte readByte(int address) {
        return this.getMemoryPage(address)[address & 0xFF];
    }

    public void writeByte(int address, byte value) {
        this.getMemoryPage((int)address)[address & 0xFF] = value;
    }

    public void fillBanks(PagedMemory source) {
        int thisBase;
        byte[][] sourceMemory = source.getMemory();
        int sourceBase = source.type.getBaseAddress() >> 8;
        int start = sourceBase > (thisBase = this.type.getBaseAddress() >> 8) ? sourceBase : thisBase;
        int sourceEnd = sourceBase + source.getMemory().length;
        int thisEnd = thisBase + this.getMemory().length;
        int end = sourceEnd < thisEnd ? sourceEnd : thisEnd;
        for (int i = start; i < end; ++i) {
            this.set(i - thisBase, sourceMemory[i - sourceBase]);
        }
    }

    public static enum Type {
        cardFirmware(51200),
        languageCard(53248),
        firmwareMain(53248),
        firmware80column(49920),
        slotRom(49408),
        ram(0);

        protected int baseAddress;

        private Type(int newBase) {
            this.baseAddress = newBase;
        }

        public int getBaseAddress() {
            return this.baseAddress;
        }
    }
}

